@extends('layouts.app')
@section('title', __('tpsTransfer::lang.setting'))

@section('content')
    <!-- Main content -->
    <section class="content">
        {!! Form::open(['url' => action('\Modules\TpsTransfer\Http\Controllers\TpsController@storeSetting'), 'method' => 'post']) !!}
            @component('components.widget', ['class' => 'box-primary', 'title' => 'Setting'])
            <table class="table table-bordered ajax_view hide-footer display" id="product_table" style="width: 100%;">
                <thead>
                <tr>
                    <th style="width:1px">#</th>
                    <th style='width: 40%'>@lang('lang_v1.name')</th>
                    <th style='width: 60%'>{{__( 'product.value' )}}</th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>1</td>
                    <td>{{__('tpsTransfer::lang.selling_period')}}</td>
                    <td>{!! Form::number('sellingPeriod', $setting['sellingPeriod'] ?? null, ['class' => 'form-control','style' => 'width:50%', 'placeholder' => __('tpsTransfer::lang.selling_period_by_days'), 'required']); !!}</td>
                </tr>
                <tr>
                    <td>2</td>
                    <td>{{__('tpsTransfer::lang.future_period')}}</td>
                    <td>{!! Form::number('futurePeriod', $setting['futurePeriod'] ?? null, ['class' => 'form-control','style' => 'width:50%', 'placeholder' => __('tpsTransfer::lang.future_period_by_days'), 'required']); !!}</td>
                </tr>
                <tr>
                    <td>3</td>
                    <td>{{__('tpsTransfer::lang.default_shipping_method')}}</td>
                    <td>{!!Form::select('shipping_method', $shippingMethods, $setting['shippingMethod'] ?? null, ['name' => 'shippingMethod', 'style' => 'width:50%', 'class' => 'form-control select2', 'required']); !!}</td>
                </tr>
                <tr>
                    <td>4</td>
                    <td>{{__('tpsTransfer::lang.disable_default_stock_transfer_module')}}</td>
                    <td>
                        {!! Form::hidden('disableDefaultStockTransfer', 0); !!}
                        {!!Form::checkbox('disableDefaultStockTransfer', 1, $setting['disableDefaultStockTransfer'] ?? false, ['class' => 'input-icheck']) !!}
                    </td>
                </tr>
                </tbody>
            </table>
            <div class="row">
                <div class="col-sm-12">
                    <button type="submit" class="btn btn-primary pull-right btn-flat">@lang('messages.save')</button>
                </div>
            </div>
        @endcomponent
        {!! Form::close() !!}

        @can('roles.view')
            @component('components.widget', ['class' => 'box-primary', 'title' => __( 'user.all_roles' )])

                <table class="table table-bordered table-striped" id="roles_table">
                    <thead>
                    <tr>
                        <th>@lang( 'business.username' )</th>
                        <th>@lang( 'user.name' )</th>
                        <th>@lang( 'user.role' )</th>
                        <th>@lang( 'business.email' )</th>
                        <th>@lang( 'messages.action' )</th>
                    </tr>
                    </thead>
                </table>
            @endcomponent

        @endcan
    </section>
    <!-- /.content -->
@endsection
@section('javascript')
    <script type="text/javascript">
        //Roles table
        $(document).ready( function(){
            var roles_table = $('#roles_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '{{action('\Modules\TpsTransfer\Http\Controllers\TpsController@indexUsers')}}',
                scrollY: "130vh",
                scrollX: true,
                scrollCollapse: true,
                buttons:[],
                columnDefs: [ {
                    "targets": 1,
                    "orderable": false,
                    "searchable": false
                } ],
                "columns":[
                    {"data":"username"},
                    {"data":"full_name"},
                    {"data":"role"},
                    {"data":"email"},
                    {"data":"action"}
                ]
            });
            $(document).on('click', 'button.delete_role_button', function(){
                swal({
                    title: LANG.sure,
                    text: LANG.confirm_delete_role,
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        var href = $(this).data('href');
                        var data = $(this).serialize();

                        $.ajax({
                            method: "DELETE",
                            url: href,
                            dataType: "json",
                            data: data,
                            success: function(result){
                                if(result.success == true){
                                    toastr.success(result.msg);
                                    roles_table.ajax.reload();
                                } else {
                                    toastr.error(result.msg);
                                }
                            }
                        });
                    }
                });
            });
        });
    </script>
@endsection