<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Spatie\Permission\Models\Permission;

class AddTpsPermissions extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('', function (Blueprint $table) {
            Permission::findOrCreate('tpsTransfer.access_all_locations_from');
            Permission::findOrCreate('tpsTransfer.access_his_locations_from');
            Permission::findOrCreate('tpsTransfer.access_none_locations_from');

            Permission::findOrCreate('tpsTransfer.access_all_locations_to');
            Permission::findOrCreate('tpsTransfer.access_his_locations_to');
            Permission::findOrCreate('tpsTransfer.access_none_locations_to');

            Permission::findOrCreate('tpsTransfer.access_add_stock_transfer');
            Permission::findOrCreate('tpsTransfer.access_prepare_stock_transfer');
            Permission::findOrCreate('tpsTransfer.access_received_stock_transfer');
            Permission::findOrCreate('tpsTransfer.access_list_stock_transfers');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('', function (Blueprint $table) {

        });
    }
}
