<?php

namespace Modules\TpsTransfer\Http\Controllers;

use Modules\TpsTransfer\Entities\NstSetting;
use \Notification;
use App\System;
use App\Utils\Util;
use App\Http\Controllers\Controller;
use Menu;

class DataController extends Controller
{
    /**
     * Defines user permissions for the module.
     * @return array
     */
    public function user_permissions()
    {

        return [
            [
                'value' => 'tpsTransfer.access_index_stock_transfers',
                'label' => __('tpsTransfer::lang.access_index_new_stock_transfers'),
                'default' => false
            ],
            [
                'value' => 'tpsTransfer.access_add_stock_transfer',
                'label' => __('tpsTransfer::lang.access_add_new_stock_transfer'),
                'default' => false
            ],
            [
                'value' => 'tpsTransfer.access_prepare_stock_transfer',
                'label' => __('tpsTransfer::lang.access_prepare_new_stock_transfer'),
                'default' => false
            ],
            [
                'value' => 'tpsTransfer.access_received_stock_transfer',
                'label' => __('tpsTransfer::lang.access_received_new_stock_transfer'),
                'default' => false
            ],
            [
                'value' => 'tpsTransfer.access_transactions_stock_transfers',
                'label' => __('tpsTransfer::lang.access_transactions_new_stock_transfer'),
                'default' => false
            ],
            [
                'value' => 'tpsTransfer.access_settings_stock_transfer',
                'label' => __('tpsTransfer::lang.access_setting_new_stock_transfer'),
                'default' => false
            ],
            [
                'value' => 'tpsTransfer.can_access_auto_add_products',
                'label' => __('tpsTransfer::lang.can_access_auto_sell_button'),
                'default' => false
            ],
            [
                'value' => 'tpsTransfer.can_delete_nst_row',
                'label' => __('tpsTransfer::lang.can_delete_stock_transfer_row'),
                'default' => false
            ],
        ];
    }

    /**
     * Adds Superadmin menus
     * @return null
     */
    public function modifyAdminMenu()
    {
        $businessId = request()->session()->get('user.business_id');
        $locationsService = new \Modules\TpsTransfer\Entities\Services\LocationsService;

        // Disable default Stock transfer module ?
        $setting = (NstSetting::where('business_id', $businessId)->first())->value ?? [];

        // try #1
        if(\Arr::get($setting, 'disableDefaultStockTransfer')){

            if($key = array_search('stock_transfers', session('business.enabled_modules'))){
                $business = session('business');
                $enabled_modules = $business->enabled_modules;
                $enabled_modules[$key] = 'x_stock_transfers';
                $business->enabled_modules = $enabled_modules;
                request()->session()->put('business', $business);
            }
        }
        else{
            if($key = array_search('x_stock_transfers', session('business.enabled_modules'))){
                $business = session('business');
                $enabled_modules = $business->enabled_modules;
                $enabled_modules[$key] = 'stock_transfers';
                $business->enabled_modules = $enabled_modules;
                request()->session()->put('business', $business);
            }
        }

        // if user has any access to tpsTransfer pages
        if (auth()->user()->can('tpsTransfer.access_index_stock_transfers') || auth()->user()->can('tpsTransfer.access_add_stock_transfer') || auth()->user()->can('tpsTransfer.access_prepare_stock_transfer') || auth()->user()->can('tpsTransfer.access_received_stock_transfer') || auth()->user()->can('tpsTransfer.access_transactions_stock_transfers') || auth()->user()->can('tpsTransfer.access_settings_stock_transfer')) {
            $locationsService = new \Modules\TpsTransfer\Entities\Services\LocationsService;

            $fromPrepare = $locationsService->getTpsIndicatorsData('from', 'prepare');
            $fromPrepareRoute = action([\Modules\TpsTransfer\Http\Controllers\TpsPrepareStockController::class, 'index']);
            $toReceive = $locationsService->getTpsIndicatorsData('to', 'receive');
            $toReceiveRoute = action([\Modules\TpsTransfer\Http\Controllers\TpsReceiveStockController::class, 'index']);

            $indicators = "
                <a href='{$fromPrepareRoute}' title='Prepare' data-toggle='tooltip' data-placement='bottom' class='btn btn-danger dropdown-toggle btn-flat pull-left m-8 btn-sm mt-10'>
                  <strong>".__('tpsTransfer::lang.out')." </strong><span class='badge'>{$fromPrepare}</span>
                </a>
                <a href='{$toReceiveRoute}' title='Receive' data-toggle='tooltip' data-placement='bottom' class='btn btn-danger dropdown-toggle btn-flat pull-left m-8 btn-sm mt-10'>
                  <strong>".__('tpsTransfer::lang.in')." </strong><span class='badge'>{$toReceive}</span>
                </a>
            ";
            /* Hashed because problem in exporting pds  ledgers */
            /*
            echo "
            <script>
                document.addEventListener('DOMContentLoaded', function(event) { 
                    $(`{$indicators}`).insertBefore('#header_shortcut_dropdown');
                });
             </script>
            ";
            */
            
            /* Try previous solution than echo */
            view()->composer('*', function ($view) use ($indicators) {
                $view->with('tps_indicators_script', $indicators);
            });
            /* End Try previous solution than echo */
            
            Menu::modify('admin-sidebar-menu', function ($menu) {
                $menu->dropdown(__('lang_v1.stock_transfers'), function ($sub) {
                    // index page
                    if(auth()->user()->can('tpsTransfer.access_index_stock_transfers')){
                        $sub->url(action([\Modules\TpsTransfer\Http\Controllers\TpsController::class, 'index']), __('tpsTransfer::lang.index'), ['icon' => 'fa fas fa-sync', 'active' => request()->route()->getName() === 'Tps-index']);
                    }

                    // add page
                    if(auth()->user()->can('tpsTransfer.access_add_stock_transfer')){
                        $sub->url(action([\Modules\TpsTransfer\Http\Controllers\TpsAddStockController::class, 'index']), __('tpsTransfer::lang.add'), ['icon' => 'fa fas fa-sync', 'active' => request()->segment(2) == 'add-stock']);
                    }

                    // prepare page
                    if(auth()->user()->can('tpsTransfer.access_prepare_stock_transfer')){
                        $sub->url(action([\Modules\TpsTransfer\Http\Controllers\TpsPrepareStockController::class, 'index']), __('tpsTransfer::lang.prepare'), ['icon' => 'fa fas fa-sync', 'active' => request()->segment(2) == 'prepare-stock']);
                    }

                    // receive page
                    if(auth()->user()->can('tpsTransfer.access_received_stock_transfer')){
                        $sub->url(action([\Modules\TpsTransfer\Http\Controllers\TpsReceiveStockController::class, 'index']), __('tpsTransfer::lang.receive'), ['icon' => 'fa fas fa-sync', 'active' => request()->segment(2) == 'receive-stock']);
                    }

                    // transaction page
                    if(auth()->user()->can('tpsTransfer.access_transactions_stock_transfers')){
                        $sub->url(action([\Modules\TpsTransfer\Http\Controllers\TpsController::class, 'transactions']), __('tpsTransfer::lang.transactions'), ['icon' => 'fa fas fa-sync', 'active' => request()->route()->getName() === 'Tps-transactions']);
                    }

                    // setting page
                    if(auth()->user()->can('tpsTransfer.access_settings_stock_transfer')){
                        $sub->url(action([\Modules\TpsTransfer\Http\Controllers\TpsController::class, 'setting']), __('tpsTransfer::lang.setting'), ['icon' => 'fa fas fa-sync', 'active' => request()->segment(2) == 'setting']);
                    }
                }, ['icon' => 'fa fas fa-sync'])->order(36);
            });
        }

        return;
    }
}
