<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNstShippingTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('nst_shipping', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            $table->string('shipping_details')->nullable();
            $table->enum('shipping_method', ['as_charge', 'different_ratio', 'equal_ratio']);
            $table->decimal('shipping_charges', 22, 4)->default(0);

            $table->string('additional_expense_key_1')->nullable();
            $table->decimal('additional_expense_value_1', 22, 4)->default(0);
            $table->string('additional_expense_key_2')->nullable();
            $table->decimal('additional_expense_value_2', 22, 4)->default(0);
            $table->string('additional_expense_key_3')->nullable();
            $table->decimal('additional_expense_value_3', 22, 4)->default(0);
            $table->string('additional_expense_key_4')->nullable();
            $table->decimal('additional_expense_value_4', 22, 4)->default(0);

            $table->integer('created_by')->unsigned();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('nst_shipping');
    }
}
