<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => ['web', 'auth', 'SetSessionData', 'language', 'timezone', 'AdminSidebarMenu'], 'prefix' => 'tps-product', 'namespace' => '\Modules\TpsTransfer\Http\Controllers'], function () {
    Route::get('/add-stock', 'TpsAddStockController@index');
    Route::post('/add-stock/table', 'TpsAddStockController@table');
    Route::post('/add-stock/auto-temp-product', 'TpsAddStockController@autoTempProduct');
    Route::get('/add-stock/manual-temp-product', 'TpsAddStockController@manualTempProduct');
    Route::get('/add-stock/manual-temp-product-table', 'TpsAddStockController@manualTempProductTable');

    Route::get('/prepare-stock', 'TpsPrepareStockController@index');
    Route::post('/prepare-stock/table', 'TpsPrepareStockController@table');
    Route::post('/prepare-stock/store', 'TpsPrepareStockController@store');
    Route::delete('/prepare-stock/destroy', 'TpsPrepareStockController@destroy');
    Route::delete('/prepare-stock/destroySelected', 'TpsPrepareStockController@destroySelected');
    Route::put('/prepare-stock/update/', 'TpsPrepareStockController@update');

    Route::post('/add-shipping', 'TpsPrepareStockController@addShippingModal');
    Route::post('/add-shipping/table', 'TpsPrepareStockController@addShippingTable');
    Route::put('/add-shipping/store', 'TpsPrepareStockController@storeShipping');

    Route::get('/receive-stock', 'TpsReceiveStockController@index');
    Route::post('/receive-stock/table', 'TpsReceiveStockController@table');
    Route::delete('/receive-stock/destroy', 'TpsReceiveStockController@destroy');
    Route::delete('/receive-stock/destroySelected', 'TpsReceiveStockController@destroySelected');
    Route::put('/receive-stock/update/', 'TpsReceiveStockController@update');
    Route::put('/receive-stock/receive/', 'TpsReceiveStockController@receive');
    Route::get('/show-product-info-modal/{id}', 'TpsController@showInfoModal');

    Route::get('/get_products', 'TpsAddStockController@get_products');
    Route::post('/insert_prepare_data', 'TpsAddStockController@insert_prepare_data');

    Route::get('/install', 'InstallController@index');
    Route::post('/install', 'InstallController@install');
    Route::get('/install/uninstall', 'InstallController@uninstall');
    Route::get('/install/update', 'InstallController@update');

    Route::get('/show-category','TpsAddStockController@showCategory');
    Route::get('/show-sub-category','TpsAddStockController@showSubCategory');

    Route::get('/', 'TpsController@index')->name('Tps-index');
    Route::post('/', 'TpsController@index');

    Route::get('/transactions', 'TpsController@transactions')->name('Tps-transactions');
    Route::post('/transactions', 'TpsController@transactions');
    Route::get('/setting', 'TpsController@setting');
    Route::post('/setting', 'TpsController@storeSetting');

    Route::get('/setting/indexUsers', 'TpsController@indexUsers');
    Route::get('/setting/editPermission/{id}', 'TpsController@editUserPermission');
    Route::put('/setting/storeUserLocation/{id}', 'TpsController@storeUserLocation');

    Route::get('/transfer/showStockTransferModal/{id}', 'TpsController@showStockTransferModal');
    Route::get('/transfer/getActivityByArguments', 'TpsController@getActivityByArguments');
    Route::post('/get-to-location-by-from-location-id', 'TpsController@getToLocationByFromLocationId');
    Route::post('/get-shipping-ids-with-locations', 'TpsController@getShippingIdsWithLocations');

    //Print Labels
    Route::get('/labels/show', 'TpsLabelsController@show');
    Route::get('/labels/add-product-row', 'TpsLabelsController@addProductRow');
    Route::get('/labels/preview', 'TpsLabelsController@preview');
});