<?php

namespace Modules\StockIssues\Http\Controllers;

use App\Utils\ModuleUtil;
use Nwidart\Menus\Facades\Menu;

class DataController
{
    /**
     * Adds Essentials menus
     * @return null
     */
    public function modifyAdminMenu()
    {
        if (auth()->user()->can('stock-issues.reports'))
            Menu::modify('admin-sidebar-menu', function ($menu) {
                $menu->url(
                    action('\Modules\StockIssues\Http\Controllers\StockReportController@index'),
                    __('Stock Reports'),
                    ['icon' => 'fa fas fa-archive', 'active' => request()->segment(1) == 'stock-issues', 'style' => config('app.env') == 'demo' ? 'background-color: #001f3f !important;' : '']
                )->order(87);
            });
    }

    /**
     * Defines user permissions for the module.
     * @return array
     */
    public function user_permissions()
    {
        return [
            [
                'value' => 'stock-issues.reports',
                'label' => 'allow view stock reports',
                'default' => false
            ],
            [
                'value' => 'stock-issues.delete-reports',
                'label' => 'delete reports',
                'default' => false
            ],
            [
                'value' => 'stock-issues.pm-delete-reports',
                'label' => 'permanently delete reports',
                'default' => false
            ]
        ];
    }
}
