<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateNstPrepareProductsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('nst_prepare_products', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('business_id')->unsigned();
            $table->foreign('business_id')->references('id')->on('business')->onDelete('cascade');
            $table->dateTime('transaction_date');
            $table->string('ref_no')->nullable();
            $table->integer('from_location_id')->unsigned();
            $table->foreign('from_location_id')->references('id')->on('business_locations');
            $table->integer('product_id')->unsigned();
            $table->foreign('product_id')->references('id')->on('products')->onDelete('cascade');
            $table->integer('variation_id')->unsigned();
            $table->foreign('variation_id')->references('id')->on('variations')->onDelete('cascade');
            $table->integer('purchase_lines_id')->unsigned()->nullable();
            $table->foreign('purchase_lines_id')->references('id')->on('purchase_lines')->onDelete('cascade');
            $table->decimal('transfer_quantity', 22, 4);
            $table->integer('to_location_id')->unsigned();
            $table->foreign('to_location_id')->references('id')->on('business_locations');

            $table->boolean('is_important')->default(false);
            $table->boolean('is_shipping_calculated')->default(false);
            $table->string('note')->nullable();

            $table->enum('status', ['prepare', 'receive', 'complete'])->default('prepare');
            $table->integer('created_by')->unsigned();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('cascade');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('nst_prepare_products');
    }
}
