<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class SharedProduct extends Model
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'token', 'business_id', 'user_id', 'products_data', 'expires_at'
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array
     */
    protected $casts = [
        'products_data' => 'array',
        'expires_at' => 'datetime',
    ];

    /**
     * Scope a query to only include valid (not expired) shared products.
     *
     * @param  \Illuminate\Database\Eloquent\Builder  $query
     * @return \Illuminate\Database\Eloquent\Builder
     */
    public function scopeValid($query)
    {
        return $query->where('expires_at', '>', now());
    }
}