@extends('layouts.app')
@section('title', 'Product Positioning (Beta)')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>Product Positioning (Beta)</h1>
</section>

<!-- Main content -->
<section class="content no-print">

    <!--Get Cash Payment Report to specific locations in custom period-->
    <div class="row">
        <form method="post" action="/additional_reports/product_racks_details">
            {{ csrf_field() }}
        <div class="col-md-12">
            @component('components.filters', ['title' => __('report.filters')])
                
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="business_locations">Select Business Location :</label>
                        <div class="input-group" style=" width: 100% !important; ">
                            <div class="row">
                                <div class="col-md-3 p-0" style="padding: 0 !important">
                                    <span class="input-group-addon" style="border: none !important;">
                                        <i class="fa fa-search" style="font-size: 20px;"></i>
                                    </span>
                                </div>
                                <div class="col-md-9" style="padding: 0 !important">
                                    <select name="business_locations[]" class="form-control bg-dark " multiple="multiple">
                                        <option value="" selected>All</option>
                                        @foreach($business_locations as $business_location)
                                        <option value="{{$business_location->id}}" >{{$business_location->name}} ({{ $business_location->location_id }})</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="brands">Select Brand :</label>
                        <div class="input-group" style=" width: 100% !important; ">
                            <div class="row">
                                <div class="col-md-3 p-0" style="padding: 0 !important">
                                    <span class="input-group-addon" style="border: none !important;">
                                        <i class="fa fa-search" style="font-size: 20px;"></i>
                                    </span>
                                </div>
                                <div class="col-md-9" style="padding: 0 !important">
                                    <select name="brands[]" class="form-control bg-dark " multiple="multiple">
                                        <option value="" selected>All</option>
                                        @foreach($brands as $brand)
                                        <option value="{{$brand->id}}" >{{$brand->name}}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="categories">Select Category :</label>
                        <div class="input-group" style=" width: 100% !important; ">
                            <div class="row">
                                <div class="col-md-3 p-0" style="padding: 0 !important">
                                    <span class="input-group-addon" style="border: none !important;">
                                        <i class="fa fa-search" style="font-size: 20px;"></i>
                                    </span>
                                </div>
                                <div class="col-md-9" style="padding: 0 !important">
                                    <select name="categories[]" class="form-control bg-dark " multiple="multiple">
                                        <option value="" selected>All</option>
                                        @foreach($data as $category)
                                            @if($category->parent_id == 0)
                                        <option value="{{$category->id}}" >{{$category->name}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-3">
                    <div class="form-group">
                        <label for="subcategories">Select Sub-Category :</label>
                        <div class="input-group" style=" width: 100% !important; ">
                            <div class="row">
                                <div class="col-md-3 p-0" style="padding: 0 !important">
                                    <span class="input-group-addon" style="border: none !important;">
                                        <i class="fa fa-search" style="font-size: 20px;"></i>
                                    </span>
                                </div>
                                <div class="col-md-9" style="padding: 0 !important">
                                    <select name="subcategories[]" class="form-control bg-dark " multiple="multiple">
                                        <option value="" selected>All</option>
                                        @foreach($data as $subcategory)
                                            @if($subcategory->parent_id != 0)
                                        <option value="{{$subcategory->id}}" >{{$subcategory->name}}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
        
                <div class="col-md-3">
                    <div class="form-group">
                        <input class="button" type="submit" value="Get Data" name="submit" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700; padding: 10px 60px;margin-top: 10px;">                     
                    </div>
                </div>

            @endcomponent
        </div>
        </form>
    </div>
    
    
    <div class="row">
        <div class="col-md-12">
            <div class="nav-tabs-custom">
            
                <div class="tab-content">
                    <h3 class="text-center">Please select the above data and click on the button</h3>
                    <h3 class="text-center">برجاء اتمام الاختيارات والضغط على الزر</h3>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .selectize-dropdown, .selectize-dropdown.form-control{
            position: absolute !important;
    }
</style>

@endsection

@section('javascript')
<script src="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/js/standalone/selectize.min.js" integrity="sha256-+C0A5Ilqmu4QcSPxrlGpaZxJ04VjsRjKu+G82kl5UJk=" crossorigin="anonymous"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/selectize.js/0.12.6/css/selectize.bootstrap3.min.css" integrity="sha256-ze/OEYGcFbPRmvCnrSeKbRTtjG4vGLHXgOqsyLFTRjg=" crossorigin="anonymous" />


    <script type="text/javascript">
    
    $(document).ready(function () {
          $('select').selectize({
              sortField: 'text'
          });
      });
      
        $(function () {

      var start = moment().subtract(29, 'days');
      var end = moment();
      $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        ranges: {
          'Today': [moment(), moment()],
          'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
          'Last 7 Days': [moment().subtract(6, 'days'), moment()],
          'Last 30 Days': [moment().subtract(29, 'days'), moment()],
          'This Month': [moment().startOf('month'), moment().endOf('month')],
          'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],

          'this year': [
            moment()
              .subtract(0, 'year')
              .startOf('year'),
            moment()
              .subtract(0, 'year')
              .endOf('year')
          ],
        }
      });
      
    });
    
    
    $(document).ready(function() {
        $('#category').change(function() {
            var selectedValue = $(this).val();
            var categoryID = selectedValue.split('_')[0];
            var subcategoryID = selectedValue.split('_')[1] || null;
            
            if (subcategoryID) {
                // Subcategory selected
                console.log("Category ID: " + categoryID + ", Subcategory ID: " + subcategoryID);
                // Add logic to send category and subcategory IDs in form submission
            } else {
                // Category selected
                console.log("Category ID: " + categoryID);
                // Add logic to send only category ID in form submission
            }
        });
    });
    


    $(document).keydown(function(e) {
        // Ctrl+1 for Queen locations
        if ((e.ctrlKey || e.metaKey) && e.which === 49) { // 49 is key code for 1
            handleLocationSelection('queen');
            return false;
        }
        
        // Ctrl+2 for Bustan locations
        if ((e.ctrlKey || e.metaKey) && e.which === 50) { // 50 is key code for 2
            handleLocationSelection('bustan');
            return false;
        }
    });
    
    function handleLocationSelection(pattern) {
        // Get the select element
        const locationSelect = $('select[name="business_locations[]"]')[0];
        const selectize = locationSelect.selectize;
        
        // Clear current selections
        selectize.clear();
        
        // Find and select matching options
        selectize.$dropdown_content.find('.option').each(function() {
            const optionText = $(this).text().toLowerCase();
            if (optionText.includes(pattern)) {
                const value = $(this).data('value');
                selectize.addItem(value);
            }
        });
    }

    </script>

@endsection