@extends('layouts.app')
@section('title', 'Register Payments Report Details (Beta)')

@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>Cashier Cash Payments Details</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        
            @component('components.filters', ['title' => __('report.filters')])

            <div class="col-md-10 mx-2">
            <label class="form-control bg-dark header-print"> Get Cash Payment Report To Specific Locations at Date Range : {{$daterange_new_formate}} </label>
            </div>

            <div class="col-md-2 mx-2">
            <a href="/additional_reports/register_payments" style="text-decoration: none;"><button class="form-control bg-dark  button" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700;">New Report</button></a>
            </div>

            @endcomponent
        <!--</div>-->
        
        
    </div>
    
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    <div class="table-responsive">
                    <table id="dtBasicExample2" class="table table-bordered table-striped text-center" >
                        <caption style="display: none;"><label class="form-control bg-dark header-print"> Get Cash Payment Report To Specific Locations at Date Range : {{$daterange_new_formate}} and printed by : {{$printed_user}} </label></caption>
                        <thead>
                            <tr>
                                <th>Business Location</th>
                                <th>Cashier Name</th>
                                <th>Net Cash "Total Cash - Total Return"</th>
                                <th>Total Cards</th>
                                <th>Register Opened At</th>
                                <th>Register Closed At</th>
                            </tr>
                        </thead>
                        <tbody>
                            <div style="display: none">
                            	{{ $total = 0 }}
                            </div>
                            @foreach($results as $result)
                            <tr>
                                
                                <td>{{$result->business_location_name}}</td>
                                <td>{{$result->cashier_first_name}} {{$result->cashier_last_name }}</td>
                                <td>{{number_format($result->totalCash - $result->totalReturn, 2)}}</td>
                                <td>{{number_format($result->totalCard , 2)}}</td>
                                <td>{{$result->created_at}}</td>
                                <td>{{$result->closed_at}}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
</section>
<!-- /.content -->

<style>
    tr.odd td:first-child,
tr.even td:first-child {
    padding-left: 4em;
}
</style>

@endsection


@section('javascript')
<script>
   $(document).ready(function () {
    $('#dtBasicExample').DataTable({  
        aLengthMenu: [[10, 25, 50, 75, -1], [10, 25, 50, 75, "All"]],
        iDisplayLength: -1,
        });
    $('#dtBasicExample2').DataTable({  
        aLengthMenu: [[10, 25, 50, 75, -1], [10, 25, 50, 75, "All"]],
        iDisplayLength: -1,
        });
});
</script>
@endsection
