@extends('layouts.app')
@section('title', __('additional_reports.user_payments_transactions'))
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>@lang('additional_reports.user_payments_transactions')</h1>
</section>

<!-- Main content -->
<section class="content no-print">


    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    <div class="table-responsive">
                    <table id="dtBasicExample" class="table table-bordered table-striped text-center" >
                        <caption style="display: none;"><label class="form-control bg-dark header-print">User ({{$user_name}}) Payments Transactions At {{$daterange_new_formate}} , printed by ({{$printed_user}})</label></caption>
                        <thead>
                            <tr>
                                <th>User Name</th>
                            </tr>
                        </thead>
                        <tbody>
                            <div style="display: none">
                                {{ $total = 0 }}
                             </div>
                            @foreach($transactions as $result)
                                <tr>
                                    <td>{{$result}}</td>
                                </tr>
                            @endforeach
                   
                        </tbody>

                    </table>
                    
                    
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection


@section('javascript')
<script>
   $(document).ready(function () {
    $('#dtBasicExample').DataTable({  aLengthMenu: [[ "All",10, 25, 50, 75, -1], [ "All",10, 25, 50, 75 , 'All']],
        iDisplayLength: -1,
        order: [[6, 'asc']],
        });
});
</script>
@endsection