@extends('layouts.app')
@section('title', __('additional_reports.user_payments_transactions'))
@section('content')

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>@lang('additional_reports.user_payments_transactions')</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        
            @component('components.filters', ['title' => __('report.filters')])




<div class="col-md-10 mx-2">
    <label class="form-control bg-dark header-print">User ({{$user_name}}) Payments Transactions At {{$daterange_new_formate}}</label>
</div>
<div class="col-md-2 mx-2">
<a href="/additional_reports/user_payments_transactions" style="text-decoration: none;"><button class="form-control bg-dark  button" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700;">@lang('additional_reports.new_report')</button></a>
</div>


            @endcomponent
    </div>

    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    <div class="table-responsive">
                    <table id="dtBasicExample" class="table table-bordered table-striped text-center" >
                        <caption style="display: none;"><label class="form-control bg-dark header-print">User ({{$user_name}}) Payments Transactions At {{$daterange_new_formate}} , printed by ({{$printed_user}})</label></caption>
                        <thead>
                            <tr>
                                <th>User Name</th>
                                <th>Transaction Type</th>
                                <th>Transaction Method</th>
                                <th>Transaction Ref No</th>
                                <th>Transaction Payment Ref No</th>
                                <th>Account Name</th>
                                <th>Transaction Paid On</th>
                                <th>Contact Name</th>
                                <th>Transaction Amount</th>
                                <th>Net</th>
                            </tr>
                        </thead>
                        <tbody>
                            <div style="display: none">
                                {{ $total = 0 }}
                             </div>
                            @foreach($transactions_payments as $result)
                                <tr>
                                    @if( ($result->transaction_type == "sell_return" && $result->is_return == 1 ) || ($result->transaction_type == "purchase_return" && $result->is_return == 0 ) || ($result->transaction_type == "sell" && $result->is_return == 0 ) )
                                    <td>{{$result->user_first_name}} {{$result->user_last_name}}</td>
                                    <td class="text-success">{{$result->transaction_type}}</td>
                                    <td>{{$result->transaction_method}}</td>
                                    <td>{{$result->transaction_ref_no}}</td>
                                    <td>{{$result->payment_ref_no}}</td>
                                    <td>{{$result->account_name}}</td>
                                    <td>{{$result->transaction_paid_on}}</td>
                                    <td>{{$result->contact_name}}</td>
                                    <td class="text-success">{{(1) * $result->transaction_amount }}</td>
                                        <div style="display: none">
                                        	{{ $total += $result->transaction_amount }}
                                        </div>
                                    <td>{{$total }}</td>
                                    @else
                                    <td>{{$result->user_first_name}} {{$result->user_last_name}}</td>
                                        @if($result->transaction_type == "sell" && $result->is_return == 1 )
                                        <td class="text-danger">{{$result->transaction_type}}_return</td>
                                        @else
                                        <td class="text-danger">{{$result->transaction_type}}</td>
                                        @endif
                                    <td>{{$result->transaction_method}}</td>
                                    <td>{{$result->transaction_ref_no}}</td>
                                    <td>{{$result->payment_ref_no}}</td>
                                    <td>{{$result->account_name}}</td>
                                    <td>{{$result->transaction_paid_on}}</td>
                                    <td>{{$result->contact_name}}</td>
                                    <td class="text-danger">{{ (-1) * $result->transaction_amount  }}</td>
                                        <div style="display: none">
                                        	{{ $total -= $result->transaction_amount }}
                                        </div>
                                    <td>{{ $total }}</td>
                                    @endif
                                </tr>
                            @endforeach
                   
                        </tbody>
                        <tfoot class="bg-gray">
                            <tr>
                                <th colspan='8' > Net</th>
                                <th colspan='2' > {{ number_format($total , 2) }} </th>
                            </tr>
                        </tfoot>
                    </table>
                    
                    
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

@endsection


@section('javascript')
<script>
   $(document).ready(function () {
    $('#dtBasicExample').DataTable({  aLengthMenu: [[ "All",10, 25, 50, 75, -1], [ "All",10, 25, 50, 75 , 'All']],
        iDisplayLength: -1,
        order: [[6, 'asc']],
        });
});
</script>
@endsection