<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shared Products</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/css/bootstrap.min.css">
    <style>
        body {
            padding: 20px;
            font-family: Arial, sans-serif;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
        }
        .product-img {
            max-width: 250px;
            max-height: 250px;
        }
        .price {
            font-weight: bold;
            color: #e10f28;
        }
        .stock-available {
            color: green;
        }
        .stock-limited {
            color: orange;
        }
        .table th {
            background-color: #f8f9fa;
        }
        .expiration-notice {
            font-size: 0.8rem;
            color: #6c757d;
            text-align: center;
            margin-top: 20px;
        }
        .container{
            max-width: 100% !important;
        }
        /* Add these rules */
        .table td,
        .table th {
            text-align: center !important;
            vertical-align: middle !important;
        }
    
        /* Update existing product-img rule */
        .product-img {
            max-width: 250px;
            max-height: 250px;
            display: block;
            margin: 0 auto; /* Center horizontally */
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Product Catalog</h1>
            <p>Here are the products you requested information about</p>
        </div>
        
        <div class="table-responsive">
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Image</th>
                        <th>SKU</th>
                        <th>Product Name</th>
                        <th>Price</th>
                        <!--<th>Stock</th>-->
                        <th>Location</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td>
                                <img src="<?php echo e($product['image_url'], false); ?>" alt="Product image" class="product-img">
                            </td>
                            <td><?php echo e($product['sku'], false); ?></td>
                            <td><?php echo e($product['name'], false); ?></td>
                            <!--<td class="price"><?php echo e($product['price'], false); ?></td>-->
                            <td class="price"><?php echo e(ceil($product['price'] / 5) * 5, false); ?></td>
                            <!--<td class="<?php echo e($product['stock'] > 10 ? 'stock-available' : 'stock-limited', false); ?>">-->
                            <!--    <?php echo e($product['stock'], false); ?>-->
                            <!--</td>-->
                            <td><?php echo e($product['location'], false); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        
        <div class="mt-4 text-center">
            <p>For more information, please contact us</p>
            
            <div class="expiration-notice">
                This link will expire on <?php echo e($expiresAt->format('F j, Y, g:i a'), false); ?>

            </div>
        </div>
    </div>
    
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@4.6.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html><?php /**PATH /home/static/public_html/resources/views/additional_reports/shared_products.blade.php ENDPATH**/ ?>