<div class="modal-dialog modal-xl" role="document">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close no-print" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            <h4 class="modal-title" id="modalTitle"> <?php echo app('translator')->get('lang_v1.stock_transfer_details'); ?> (<b><?php echo app('translator')->get('purchase.ref_no'); ?>:</b> #<?php echo e($nstProduct->id, false); ?>)
            </h4>
        </div>
        <div class="modal-body">
            <div class="row invoice-info">
                <div class="col-sm-4 invoice-col">
                    <?php echo app('translator')->get('lang_v1.location_from'); ?>:
                    <address>
                        <strong><?php echo e($nstProduct->from_location->name, false); ?></strong>

                        <?php if(!empty($nstProduct->from_location->landmark)): ?>
                            <br><?php echo e($nstProduct->from_location->landmark, false); ?>

                        <?php endif; ?>

                        <?php if(!empty($nstProduct->from_location->city) || !empty($nstProduct->from_location->state) || !empty($nstProduct->from_location->country)): ?>
                            <br><?php echo e(implode(',', array_filter([$nstProduct->from_location->city, $nstProduct->from_location->state, $nstProduct->from_location->country])), false); ?>

                        <?php endif; ?>

                        <?php if(!empty($nstProduct->from_location->mobile)): ?>
                            <br><?php echo app('translator')->get('contact.mobile'); ?>: <?php echo e($nstProduct->from_location->mobile, false); ?>

                        <?php endif; ?>
                        <?php if(!empty($nstProduct->from_location->email)): ?>
                            <br><?php echo e(__('business.email'), false); ?>: <?php echo e($nstProduct->from_location->email, false); ?>

                        <?php endif; ?>
                    </address>
                </div>

                <div class="col-md-4 invoice-col">
                    <?php echo app('translator')->get('lang_v1.location_to'); ?>:
                    <address>
                        <strong><?php echo e($nstProduct->to_location->name, false); ?></strong>

                        <?php if(!empty($nstProduct->to_location->landmark)): ?>
                            <br><?php echo e($nstProduct->to_location->landmark, false); ?>

                        <?php endif; ?>

                        <?php if(!empty($nstProduct->to_location->city) || !empty($nstProduct->to_location->state) || !empty($nstProduct->to_location->country)): ?>
                            <br><?php echo e(implode(',', array_filter([$nstProduct->to_location->city, $nstProduct->to_location->state, $nstProduct->to_location->country])), false); ?>

                        <?php endif; ?>

                        <?php if(!empty($nstProduct->to_location->mobile)): ?>
                            <br><?php echo app('translator')->get('contact.mobile'); ?>: <?php echo e($nstProduct->to_location->mobile, false); ?>

                        <?php endif; ?>
                        <?php if(!empty($nstProduct->to_location->email)): ?>
                            <br><?php echo e(__('business.email'), false); ?>: <?php echo e($nstProduct->to_location->email, false); ?>

                        <?php endif; ?>
                    </address>
                </div>

                <div class="col-sm-4 invoice-col">
                    <b><?php echo app('translator')->get('purchase.ref_no'); ?>:</b> #<?php echo e($nstProduct->ref_no, false); ?><br/>
                    <b><?php echo app('translator')->get('messages.date'); ?>:</b> <?php echo e(\Carbon::createFromTimestamp(strtotime($nstProduct->transaction_date))->format(session('business.date_format') . ' ' . 'h:i A'), false); ?><br/>
                    <b><?php echo app('translator')->get('sale.status'); ?>:</b> <?php echo e($nstProduct->status ?? '', false); ?>

                </div>
            </div>

            <br>
            <div class="row">
                <div class="col-xs-12">
                    <div class="table-responsive">
                        <table class="table bg-gray">
                            <tr class="bg-green">
                                <th><?php echo app('translator')->get('product.sku'); ?></th>
                                <th><?php echo app('translator')->get('sale.product'); ?></th>
                                <th><?php echo app('translator')->get('sale.qty'); ?></th>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_purchase_price')): ?>
                                    <th><?php echo app('translator')->get('sale.unit_price'); ?></th>
                                    <th><?php echo app('translator')->get('sale.subtotal'); ?></th>
                                <?php endif; ?>
                            </tr>
                            <tr>
                                <td><?php echo e($nstProduct->product->sku, false); ?></td>
                                <td>
                                    <?php echo e($nstProduct->product->name, false); ?>

                                    <?php if($nstProduct->purchase_line && !empty($nstProduct->purchase_line)): ?>
                                        <?php if(!empty($nstProduct->purchase_line->lot_number)): ?>
                                            <?php echo e($nstProduct->purchase_line->lot_number, false); ?>

                                        <?php endif; ?>
                                        <?php if(!empty($nstProduct->purchase_line->exp_date)): ?>
                                            - <?php echo e(\Carbon::createFromTimestamp(strtotime($nstProduct->purchase_line->exp_date))->format(session('business.date_format')), false); ?>

                                        <?php endif; ?>
                                    <?php else: ?>
                                        <strong><?php echo app('translator')->get('lang_v1.lot_n_expiry'); ?></strong>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e(number_format($nstProduct->transfer_quantity, session('business.quantity_precision', 2), session('currency')['decimal_separator'], session('currency')['thousand_separator']), false); ?> <?php if(!empty($nstProduct->sub_unit)): ?> <?php echo e($nstProduct->sub_unit->short_name, false); ?> <?php else: ?> <?php echo e($nstProduct->product->unit->short_name, false); ?> <?php endif; ?></td>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_purchase_price')): ?>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true"><?php echo e($nstProduct->unit_price_after_shipping, false); ?></span>
                                    </td>
                                    <td>
                                        <span class="display_currency" data-currency_symbol="true"><?php echo e($nstProduct->unit_price_after_shipping * $nstProduct->transfer_quantity, false); ?></span>
                                    </td>
                                <?php endif; ?>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
            <br>
            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('view_purchase_price')): ?>
                <div class="row">

                    <div class="col-xs-12 col-md-6 col-md-offset-6">
                        <div class="table-responsive">
                            <table class="table">
                                <tr>
                                    <th><?php echo app('translator')->get('lang_v1.purchase_price'); ?> <?php echo app('translator')->get('sale.subtotal'); ?>: </th>
                                    <td></td>
                                    <td><span class="display_currency pull-right" data-currency_symbol="true"><?php echo e($nstProduct->unit_price_after_shipping * $nstProduct->transfer_quantity, false); ?></span></td>
                                </tr>
                                <?php if( !empty( $nstProduct->shipping ) ): ?>
                                    <tr>
                                        <th><?php echo app('translator')->get('purchase.additional_shipping_charges'); ?>:</th>
                                        <td><b>(+)</b></td>
                                        <td><span class="display_currency pull-right" data-currency_symbol="true"><?php echo e(floatval($nstProduct->value_per_unit) * floatval($transferQuantity), false); ?></span></td>
                                    </tr>
                                <?php endif; ?>
                                <tr>
                                    <th><?php echo app('translator')->get('purchase.purchase_total'); ?>:</th>
                                    <td></td>
                                    <td><span class="display_currency pull-right" data-currency_symbol="true" ><?php echo e((floatval($nstProduct->value_per_unit) * floatval($nstProduct->transfer_quantity)) + (floatval($nstProduct->unit_price_after_shipping) * floatval($nstProduct->transfer_quantity)), false); ?></span></td>
                                </tr>
                            </table>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-sm-6">
                    <strong><?php echo app('translator')->get('purchase.additional_notes'); ?>:</strong><br>
                    <p class="well well-sm no-shadow bg-gray">
                        <?php if($nstProduct->note): ?>
                            <?php echo e($nstProduct->note, false); ?>

                        <?php else: ?>
                            --
                        <?php endif; ?>
                    </p>
                </div>
            </div>
            <div class="row">
                <div class="col-md-12">
                    <strong><?php echo e(__('lang_v1.activities'), false); ?>:</strong><br>
                    <table class="table table-condensed">
                        <tr>
                            <th><?php echo app('translator')->get('lang_v1.date'); ?></th>
                            <th><?php echo app('translator')->get('messages.action'); ?></th>
                            <th><?php echo app('translator')->get('lang_v1.by'); ?></th>
                            <th><?php echo app('translator')->get('brand.note'); ?></th>
                        </tr>
                        <tr>
                            <td><?php echo e(\Carbon::createFromTimestamp(strtotime($nstProduct->created_at))->format(session('business.date_format') . ' ' . 'h:i A'), false); ?></td>
                            <td>
                                <?php echo e(__('lang_v1.created'), false); ?>

                            </td>
                            <td>
                                <?php echo e($nstProduct->createdBy->user_full_name ?? '', false); ?>

                            </td>
                            <td>
                            </td>
                        </tr>
                        <?php if(!empty($activities)): ?>
                            <?php $__empty_1 = true; $__currentLoopData = $activities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $activity): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e(\Carbon::createFromTimestamp(strtotime($activity->created_at))->format(session('business.date_format') . ' ' . 'h:i A'), false); ?></td>
                                    <td>
                                        <?php echo e(__('lang_v1.' . $activity->description), false); ?>

                                    </td>
                                    <td>
                                        <?php echo e($activity->causer->user_full_name ?? '', false); ?>

                                        <?php if(!empty($activity->getExtraProperty('from_api'))): ?>
                                            <br>
                                            <span class="label bg-gray"><?php echo e($activity->getExtraProperty('from_api'), false); ?></span>
                                        <?php endif; ?>

                                        <?php if(!empty($activity->getExtraProperty('is_automatic'))): ?>
                                            <span class="label bg-gray"><?php echo app('translator')->get('lang_v1.automatic'); ?></span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <?php if($activity->description == 'edited'): ?>
                                            <?php
                                              $diff = array_diff($activity->properties->toArray()['old'], $activity->properties->toArray()['attributes'])
                                            ?>
                                            <?php $__currentLoopData = $diff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attribute => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <b><?php echo e(__('tpsTransfer::lang.old'), false); ?> <?php echo $attribute; ?></b> : <?php echo $value; ?>

                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center">
                                        <?php echo app('translator')->get('purchase.no_records_found'); ?>
                                    </td>
                                </tr>
                            <?php endif; ?>
                        <?php endif; ?>
                    </table>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-primary no-print" aria-label="Print"
                    onclick="$(this).closest('div.modal-content').printThis();"><i class="fa fa-print"></i> <?php echo app('translator')->get( 'messages.print' ); ?>
            </button>
            <button type="button" class="btn btn-default no-print" data-dismiss="modal"><?php echo app('translator')->get( 'messages.close' ); ?></button>
        </div>
    </div>
</div><?php /**PATH /home/static/public_html/Modules/TpsTransfer/Providers/../Resources/views/nst-info-modal.blade.php ENDPATH**/ ?>