
<?php $__env->startSection('title', __('lang_v1.backup')); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <?php echo app('translator')->get('Stock Reports'); ?>
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <?php if(session('notification') || !empty($notification)): ?>
            <div class="row">
                <div class="col-sm-12">
                    <div class="alert alert-danger alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        <?php if(!empty($notification['msg'])): ?>
                            <?php echo e($notification['msg'], false); ?>

                        <?php elseif(session('notification.msg')): ?>
                            <?php echo e(session('notification.msg'), false); ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-sm-12">
                <?php $__env->startComponent('components.filters', ['title' => __('report.filters'), 'class' => 'box-solid']); ?>
                    <form action="<?php echo e(action('\Modules\StockIssues\Http\Controllers\StockReportController@index'), false); ?>">
                        <div class="col-md-3">
                            <div class="form-group">
                                <?php echo Form::label('filter_location_id',  __('purchase.business_location') . ':'); ?>

                                <?php echo Form::select('filter_location_id', $business_locations, request('filter_location_id'), ['class' => 'form-control select2', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all') ]); ?>

                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Submit</button>
                    </form>
                    <br>
                    <hr>
                    <strong>To enable auto backup you must setup a cron job with this command:</strong><br>
                    <code><?php echo e($cronJob, false); ?></code> <br>
                    <strong>To enable auto backup & fix you must setup a cron job with this command:</strong><br>
                    <code><?php echo e($cronJobFix, false); ?></code>
                <?php echo $__env->renderComponent(); ?>
                <?php if(!is_null($reports)): ?>
                    <?php $__env->startComponent('components.widget', ['class' => 'box-primary']); ?>
                        <?php if($reports->count() > 0): ?>
                            <table class="table table-striped table-bordered">
                                <thead>
                                <tr>
                                    <th><?php echo app('translator')->get('lang_v1.file'); ?></th>
                                    <th>product count</th>
                                    <th><?php echo app('translator')->get('lang_v1.date'); ?></th>
                                    <th><?php echo app('translator')->get('lang_v1.age'); ?></th>
                                    <th><?php echo app('translator')->get('messages.actions'); ?></th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php $__currentLoopData = $reports; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $report): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(basename($report->path), false); ?></td>
                                        <td><?php echo e($report->products_count, false); ?></td>
                                        <td><?php echo e($report->created_at->toDateTimeString(), false); ?></td>
                                        <td><?php echo e($report->created_at->diffForHumans(Carbon::now()), false); ?></td>
                                        <td>
                                            <?php if(is_null($report->deleted_at)): ?>
                                                <a class="btn btn-xs btn-success" target="_blank"
                                                   href="<?php echo e(URL::signedRoute('stock-issues.reports.download', $report), false); ?>">
                                                    <i class="fa fa-cloud-download"></i>
                                                    <?php echo app('translator')->get('lang_v1.download'); ?>
                                                </a>
                                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock-issues.delete-reports')): ?>
                                                    <a class="btn btn-xs btn-danger link_confirmation"
                                                       data-button-type="delete"
                                                       href="<?php echo e(URL::signedRoute('stock-issues.reports.delete', $report), false); ?>">
                                                        <i class="fa fa-trash-o"></i>
                                                        <?php echo app('translator')->get('messages.delete'); ?>
                                                    </a>
                                                <?php endif; ?>
                                            <?php endif; ?>
                                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('stock-issues.pm-delete-reports')): ?>
                                                <a class="btn btn-xs btn-warning link_confirmation"
                                                   data-button-type="delete"
                                                   href="<?php echo e(URL::signedRoute('stock-issues.reports.permanently-delete', $report), false); ?>">
                                                    Permanently Delete
                                                </a>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <?php echo e($reports->appends(['filter_location_id' => request('filter_location_id', '')])->links(), false); ?>

                        <?php else: ?>
                            <div class="well">
                                <h4>There are no reports</h4>
                            </div>
                        <?php endif; ?>
                    <?php echo $__env->renderComponent(); ?>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/static/public_html/Modules/StockIssues/Providers/../Resources/views/reports.blade.php ENDPATH**/ ?>