<?php $__env->startSection('title', __('tpsTransfer::lang.setting')); ?>

<?php $__env->startSection('content'); ?>
    <!-- Main content -->
    <section class="content">
        <?php echo Form::open(['url' => action('\Modules\TpsTransfer\Http\Controllers\TpsController@storeSetting'), 'method' => 'post']); ?>

            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => 'Setting']); ?>
            <table class="table table-bordered ajax_view hide-footer display" id="product_table" style="width: 100%;">
                <thead>
                <tr>
                    <th style="width:1px">#</th>
                    <th style='width: 40%'><?php echo app('translator')->get('lang_v1.name'); ?></th>
                    <th style='width: 60%'><?php echo e(__( 'product.value' ), false); ?></th>
                </tr>
                </thead>
                <tbody>
                <tr>
                    <td>1</td>
                    <td><?php echo e(__('tpsTransfer::lang.selling_period'), false); ?></td>
                    <td><?php echo Form::number('sellingPeriod', $setting['sellingPeriod'] ?? null, ['class' => 'form-control','style' => 'width:50%', 'placeholder' => __('tpsTransfer::lang.selling_period_by_days'), 'required']); ?></td>
                </tr>
                <tr>
                    <td>2</td>
                    <td><?php echo e(__('tpsTransfer::lang.future_period'), false); ?></td>
                    <td><?php echo Form::number('futurePeriod', $setting['futurePeriod'] ?? null, ['class' => 'form-control','style' => 'width:50%', 'placeholder' => __('tpsTransfer::lang.future_period_by_days'), 'required']); ?></td>
                </tr>
                <tr>
                    <td>3</td>
                    <td><?php echo e(__('tpsTransfer::lang.default_shipping_method'), false); ?></td>
                    <td><?php echo Form::select('shipping_method', $shippingMethods, $setting['shippingMethod'] ?? null, ['name' => 'shippingMethod', 'style' => 'width:50%', 'class' => 'form-control select2', 'required']); ?></td>
                </tr>
                <tr>
                    <td>4</td>
                    <td><?php echo e(__('tpsTransfer::lang.disable_default_stock_transfer_module'), false); ?></td>
                    <td>
                        <?php echo Form::hidden('disableDefaultStockTransfer', 0); ?>

                        <?php echo Form::checkbox('disableDefaultStockTransfer', 1, $setting['disableDefaultStockTransfer'] ?? false, ['class' => 'input-icheck']); ?>

                    </td>
                </tr>
                </tbody>
            </table>
            <div class="row">
                <div class="col-sm-12">
                    <button type="submit" class="btn btn-primary pull-right btn-flat"><?php echo app('translator')->get('messages.save'); ?></button>
                </div>
            </div>
        <?php echo $__env->renderComponent(); ?>
        <?php echo Form::close(); ?>


        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles.view')): ?>
            <?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __( 'user.all_roles' )]); ?>

                <table class="table table-bordered table-striped" id="roles_table">
                    <thead>
                    <tr>
                        <th><?php echo app('translator')->get( 'business.username' ); ?></th>
                        <th><?php echo app('translator')->get( 'user.name' ); ?></th>
                        <th><?php echo app('translator')->get( 'user.role' ); ?></th>
                        <th><?php echo app('translator')->get( 'business.email' ); ?></th>
                        <th><?php echo app('translator')->get( 'messages.action' ); ?></th>
                    </tr>
                    </thead>
                </table>
            <?php echo $__env->renderComponent(); ?>

        <?php endif; ?>
    </section>
    <!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startSection('javascript'); ?>
    <script type="text/javascript">
        //Roles table
        $(document).ready( function(){
            var roles_table = $('#roles_table').DataTable({
                processing: true,
                serverSide: true,
                ajax: '<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsController@indexUsers'), false); ?>',
                scrollY: "130vh",
                scrollX: true,
                scrollCollapse: true,
                buttons:[],
                columnDefs: [ {
                    "targets": 1,
                    "orderable": false,
                    "searchable": false
                } ],
                "columns":[
                    {"data":"username"},
                    {"data":"full_name"},
                    {"data":"role"},
                    {"data":"email"},
                    {"data":"action"}
                ]
            });
            $(document).on('click', 'button.delete_role_button', function(){
                swal({
                    title: LANG.sure,
                    text: LANG.confirm_delete_role,
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                }).then((willDelete) => {
                    if (willDelete) {
                        var href = $(this).data('href');
                        var data = $(this).serialize();

                        $.ajax({
                            method: "DELETE",
                            url: href,
                            dataType: "json",
                            data: data,
                            success: function(result){
                                if(result.success == true){
                                    toastr.success(result.msg);
                                    roles_table.ajax.reload();
                                } else {
                                    toastr.error(result.msg);
                                }
                            }
                        });
                    }
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/static/public_html/Modules/TpsTransfer/Providers/../Resources/views/nst-setting.blade.php ENDPATH**/ ?>