<?php $__env->startSection('title', 'Price Change Details'); ?>

<?php $__env->startSection('content'); ?>

<!-- Content Header (Page header) -->
<section class="content-header no-print">
    <h1>Price Change Details</h1>
</section>

<!-- Main content -->
<section class="content no-print">
    <div class="row">
        
            <?php $__env->startComponent('components.filters', ['title' => __('report.filters')]); ?>
            
            <div class="col-md-10 mx-2">
            <label class="form-control bg-dark header-print">Price Change Details By Ratio <?php echo e($ratio, false); ?> %</label>
            </div>

            <div class="col-md-2 mx-2">
            <a href="/additional_reports/price_change" style="text-decoration: none;"><button class="form-control bg-dark  button" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700;">New Report</button></a>
            </div>

            <?php echo $__env->renderComponent(); ?>
        <!--</div>-->
        
        
    </div>
    
    <form method="post" action="/additional_reports/price_change_calculations">
        <?php echo e(csrf_field(), false); ?>

    
    <div class="row">
        <div class="col-md-12">
            <div class="box">
                <div class="box-body">
                    <div class="table-responsive">
                    <table id="dtBasicExample" class="table table-bordered table-striped text-center" >
                        <!--<caption style="display: none;"><label class="form-control bg-dark header-print"> Inventory Control To Location <?php echo e($location_name, false); ?> and printed by : <?php echo e($printed_user, false); ?> </label></caption>-->
                        <thead>
                            <tr>
                                <th>Product Image</th>
                                <th>Product Name</th>
                                <th>Product SKU</th>
                                <th>Purchase Price Inc Tax</th>
                                <th>Sell Price Inc Tax</th>
                                <th>Current Profit Percent "%"</th>
                                <th>New Selling Price (sell price will be equal to sell price inc tax)</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $products_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                
                                <td>
                                    <div class="thumbnail">
                      					<img src="<?php echo e($product_data->product_image, false); ?>" alt="Product image">
                      				</div>
                                </td>
                                <td>
                                    <?php echo e($product_data->product_name, false); ?>

                                    <input type="hidden" name="variation[<?php echo e($product_data->variation_id, false); ?>][variation_id]" value="<?php echo e($product_data->variation_id, false); ?>">
                                </td>
                                <td>
                                    <?php echo e($product_data->product_sku, false); ?>

                                </td>
                                <td>
                                    <?php echo e($product_data->dpp_inc_tax, false); ?>

                                    <input type="hidden" name="variation[<?php echo e($product_data->variation_id, false); ?>][dpp_inc_tax]" value="<?php echo e($product_data->dpp_inc_tax, false); ?>">
                                </td>
                                <td>
                                    <?php echo e($product_data->sell_price_inc_tax, false); ?>

                                    <input type="hidden" name="variation[<?php echo e($product_data->variation_id, false); ?>][sell_price_inc_tax]" value="<?php echo e($product_data->sell_price_inc_tax, false); ?>">
                                </td>
                                <td>
                                    <?php echo e($product_data->profit_percent, false); ?>

                                </td>
                                <td>
                                    <input type="text" name="variation[<?php echo e($product_data->variation_id, false); ?>][new_selling_price_inc_tax]" value="<?php echo e(($product_data->sell_price_inc_tax) * ($ratio/100), false); ?>" >
                                </td>

                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="form-group">
        <input class="button" type="submit" value="Send Data" name="submit" style="background: #e10f28 !important; color: white; border-radius: 50px; border-style: none; font-weight: 700; padding: 10px 60px;margin-top: 10px;">                     
    </div>
    </form>
    
</section>
<!-- /.content -->

<style>
    tr.odd td:first-child,
tr.even td:first-child {
    padding-left: 4em;
}
</style>

<?php $__env->stopSection(); ?>


<?php $__env->startSection('javascript'); ?>
<script>
  $(document).ready(function () {

    $('#dtBasicExample').DataTable({  
        aLengthMenu: [[10, 25, 50, 75, -1], [10, 25, 50, 75, "All"]],
        iDisplayLength: -1,
        });
        
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/static/public_html/resources/views/additional_reports/price_change_details.blade.php ENDPATH**/ ?>