<div class="row">
    <div class="col-md-4">
        <div class="form-group">
            <?php echo Form::label('manual_category_id', __('category.select_parent_category'). ':'); ?>

            <?php echo Form::select('manual_category_id', $categories, null, ['id' => 'manual_category_id', 'class' => 'form-control select2 categories-select-list', 'style' => 'width:100%', 'placeholder' => __('lang_v1.all'), 'onchange' => 'autoChangeDataTable();', 'data-sub-id' => '#manual_sub_category_id']); ?>

        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <?php echo Form::label('manual_sub_category_id', 'Select sub '.__('category.category'). ':'); ?>

            <?php echo Form::select('manual_sub_category_id', [], null, ['id' => 'manual_sub_category_id', 'class' => 'form-control select2', 'style' => 'width:100%', 'onchange' => 'autoChangeDataTable();']); ?>

        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group">
            <?php echo Form::label('brand_id', 'Select sub '.__('brand.brand_name'). ':'); ?>

            <?php echo Form::select('brand_id', $brands, null, ['id' => 'brand_id', 'class' => 'form-control select2', 'style' => 'width:100%', 'onchange' => 'autoChangeDataTable();']); ?>

        </div>
    </div>
</div>
<?php $__env->startComponent('components.widget', ['class' => 'box-primary', 'title' => __('lang_v1.list_products')]); ?>
    <table class="table table-bordered table-striped hide-footer" style="width: 100%;" id="add-product-table">
        <thead>
        <tr>
            <th style="width:1px"><input id="selectAll" value="1" type="checkbox"></th>
            <th><?php echo app('translator')->get('sale.product'); ?></th>
            <th><?php echo app('translator')->get('product.sku'); ?></th>
            <th><?php echo app('translator')->get('product.category'); ?></th>
            <th><?php echo app('translator')->get('product.brand'); ?></th>
            <th><?php echo app('translator')->get('tpsTransfer::lang.from_location_stock'); ?></th>
            <th><?php echo app('translator')->get('tpsTransfer::lang.to_location_stock'); ?></th>
        </tr>
        </thead>
    </table>
<?php echo $__env->renderComponent(); ?>
<script type="text/javascript">
    var temp_rows_selected = [];

    $(document).ready(function () {
        __select2($('.select2'));
        // autoChangeDataTable();

        // Array holding selected row IDs
        var table = $('#add-product-table').DataTable({
            'processing': true,
            'serverSide': true,
            'ajax': {
                url: '<?php echo e(action('\Modules\TpsTransfer\Http\Controllers\TpsAddStockController@manualTempProductTable'), false); ?>',
                data: function (d) {
                    d.from_location_id = $('#from_location_id').val()
                    d.to_location_id = $('#to_location_id').val()
                    d.category_id = $('#manual_category_id').val()
                    d.sub_category_id = $('#manual_sub_category_id').val()
                    d.brand_id = $('#brand_id').val()
                }
            },
            'fixedHeader': false,
            'columnDefs': [{
                'targets': 0,
                'searchable': false,
                'orderable': false,
                'width': '1px',
            }],
            'scrollY': "130vh",
            'scrollX': true,
            'scrollCollapse': true,
            'order': [1, 'asc'],
            'rowCallback': function (row, data, dataIndex) {
                // Get row ID
                var productId = data['id'];
                var variationId = data['variation_id'];

                // If row ID is in the list of selected row IDs
                if ($.inArray(productId + '-' + variationId, temp_rows_selected) !== -1) {
                    $(row).find('input[type="checkbox"]').prop('checked', true);
                    $(row).addClass('selected');
                }
            },
            'columns': [
                {data: 'checkbox',  name: "checkbox" ,sortable: false, searchable: false, className: "input"},
                {data: "product", name: "products.name"},
                {data: "sku", name: "products.sku"},
                {data: "category", name: "c1.name"},
                {data: "brand", name: "brands.name"},
                {data: "current_stock", name: "current_stock", searchable: false},
                {data: "to_current_stock", name: "to_current_stock", searchable: false},
            ],
            'lengthMenu': [[10, 25, 50, 200, 500], [10, 25, 50, 200, 500]],
            'pageLength': 10,
            'searchDelay': 10
        });

        $('#add-product-table tbody').on('click', 'tr td:not(".input")', function () {
            checkbox = $(this).parent().find('input[type=checkbox]');
            checkbox.prop("checked", !checkbox.prop("checked")).change();
        });

        // Handle form submission event
        $('#add_product_modal_buttom').on('click', function (e) {
            // Prevent actual form submission
            e.preventDefault();

            // Send selected rows to products datatable
            reloadProductDatatable(temp_rows_selected)
            temp_rows_selected = [];
            // Hide add product modal
            $("#add_product").modal('hide');
        });
    });
    //check all rows
    $('#selectAll').click(function () {
        $('.pvidCheckbox').prop('checked', $(this).is(":checked")).change()
    });

    $(document).on('change', '.pvidCheckbox',function () {
        // Determine whether row ID is in the list of selected row IDs
        var index = $.inArray($(this).data('pvid'), temp_rows_selected);
        var tr = $(this).closest('tr');

        // If checkbox is checked and row ID is not in list of selected row IDs
        if (this.checked && index === -1) {
            temp_rows_selected.push($(this).data('pvid'));
            tr.addClass('selected');

            // Otherwise, if checkbox is not checked and row ID is in list of selected row IDs
        } else if (!this.checked && index !== -1) {
            temp_rows_selected.splice(index, 1);
            tr.removeClass('selected');
        }
    });

    function autoChangeDataTable() {
        $('#add-product-table').DataTable().ajax.reload();
    }
</script><?php /**PATH /home/static/public_html/Modules/TpsTransfer/Providers/../Resources/views/add_product.blade.php ENDPATH**/ ?>