<?php

use Illuminate\Support\Facades\Route;
use Modules\TpsTransfer\Http\Controllers\InstallController;
use Modules\TpsTransfer\Http\Controllers\TpsAddStockController;
use Modules\TpsTransfer\Http\Controllers\TpsPrepareStockController;
use Modules\TpsTransfer\Http\Controllers\TpsReceiveStockController;
use Modules\TpsTransfer\Http\Controllers\TpsController;
use Modules\TpsTransfer\Http\Controllers\TpsLabelsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['middleware' => ['web', 'auth', 'SetSessionData', 'language', 'timezone', 'AdminSidebarMenu'], 'prefix' => 'tps-product'], function () {
    Route::get('/add-stock', [TpsAddStockController::class, 'index']);
    Route::post('/add-stock/table', [TpsAddStockController::class, 'table']);
    Route::post('/add-stock/auto-temp-product', [TpsAddStockController::class, 'autoTempProduct']);
    Route::get('/add-stock/manual-temp-product', [TpsAddStockController::class, 'manualTempProduct']);
    Route::get('/add-stock/manual-temp-product-table', [TpsAddStockController::class, 'manualTempProductTable']);

    Route::get('/prepare-stock', [TpsPrepareStockController::class, 'index']);
    Route::post('/prepare-stock/table', [TpsPrepareStockController::class, 'table']);
    Route::post('/prepare-stock/store', [TpsPrepareStockController::class, 'store']);
    Route::delete('/prepare-stock/destroy', [TpsPrepareStockController::class, 'destroy']);
    Route::delete('/prepare-stock/destroySelected', [TpsPrepareStockController::class, 'destroySelected']);
    Route::put('/prepare-stock/update/', [TpsPrepareStockController::class, 'update']);

    Route::post('/add-shipping', [TpsPrepareStockController::class, 'addShippingModal']);
    Route::post('/add-shipping/table', [TpsPrepareStockController::class, 'addShippingTable']);
    Route::put('/add-shipping/store', [TpsPrepareStockController::class, 'storeShipping']);

    Route::get('/receive-stock', [TpsReceiveStockController::class, 'index']);
    Route::post('/receive-stock/table', [TpsReceiveStockController::class, 'table']);
    Route::delete('/receive-stock/destroy', [TpsReceiveStockController::class, 'destroy']);
    Route::delete('/receive-stock/destroySelected', [TpsReceiveStockController::class, 'destroySelected']);
    Route::put('/receive-stock/update/', [TpsReceiveStockController::class, 'update']);
    Route::put('/receive-stock/receive/', [TpsReceiveStockController::class, 'receive']);
    Route::get('/show-product-info-modal/{id}', [TpsController::class, 'showInfoModal']);

    Route::get('/get_products', [TpsAddStockController::class, 'get_products']);
    Route::post('/insert_prepare_data', [TpsAddStockController::class, 'insert_prepare_data']);

    Route::get('/install', [InstallController::class, 'index']);
    Route::post('/install', [InstallController::class, 'install']);
    Route::get('/install/uninstall', [InstallController::class, 'uninstall']);
    Route::get('/install/update', [InstallController::class, 'update']);

    Route::get('/show-category', [TpsAddStockController::class, 'showCategory']);
    Route::get('/show-sub-category', [TpsAddStockController::class, 'showSubCategory']);

    Route::get('/', [TpsController::class, 'index'])->name('Tps-index');
    Route::post('/', [TpsController::class, 'index']);

    Route::get('/transactions', [TpsController::class, 'transactions'])->name('Tps-transactions');
    Route::post('/transactions', [TpsController::class, 'transactions']);
    Route::get('/setting', [TpsController::class, 'setting']);
    Route::post('/setting', [TpsController::class, 'storeSetting']);

    Route::get('/setting/indexUsers', [TpsController::class, 'indexUsers']);
    Route::get('/setting/editPermission/{id}', [TpsController::class, 'editUserPermission']);
    Route::put('/setting/storeUserLocation/{id}', [TpsController::class, 'storeUserLocation']);

    Route::get('/transfer/showStockTransferModal/{id}', [TpsController::class, 'showStockTransferModal']);
    Route::get('/transfer/getActivityByArguments', [TpsController::class, 'getActivityByArguments']);
    Route::post('/get-to-location-by-from-location-id', [TpsController::class, 'getToLocationByFromLocationId']);
    Route::post('/get-shipping-ids-with-locations', [TpsController::class, 'getShippingIdsWithLocations']);

    //Print Labels
    Route::get('/labels/show', [TpsLabelsController::class, 'show']);
    Route::get('/labels/add-product-row', [TpsLabelsController::class, 'addProductRow']);
    Route::get('/labels/preview', [TpsLabelsController::class, 'preview']);
});